/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/core/internal/pch.h"

#include "twitchsdk/core/standardsystemclock.h"

#include <chrono>

using std::chrono::steady_clock;

ttv::StandardSystemClock::StandardSystemClock() {
  mFrequency = steady_clock::period::den / steady_clock::period::num;
}

uint64_t ttv::StandardSystemClock::GetFrequency() {
  return mFrequency;
}

uint64_t ttv::StandardSystemClock::GetTime() {
  steady_clock::duration curTime = steady_clock::now().time_since_epoch();
  return static_cast<uint64_t>(curTime.count());
}
