/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/core/internal/pch.h"

#include "twitchsdk/core/standardthread.h"

ttv::StandardThread::StandardThread(ThreadProc threadProc, const std::string& name)
    : mThreadProc(threadProc), mName(name) {}

ttv::StandardThread::~StandardThread() {
  // deleting an active thread will crash so make sure it's done
  if (Joinable()) {
    Join();
  }

  mThread.reset();

  ttv::trace::Message("Thread", MessageLevel::Info, "Thread destroyed");
}

void ttv::StandardThread::Run() {
  // TODO - if we want to name the thread we can get the native_handle from std::thread
  // and use pthread_setname_np()
  mThread = std::make_unique<std::thread>(std::thread([this] {
    ttv::trace::Message("Thread", MessageLevel::Info, "Thread %s starting", mName.c_str());

    mThreadProc();

    ttv::trace::Message("Thread", MessageLevel::Info, "Thread %s done", mName.c_str());
  }));

  ttv::trace::Message("Thread", MessageLevel::Info, "Thread created");
}

void ttv::StandardThread::Join() {
  TTV_ASSERT(mThread != nullptr);
  TTV_ASSERT(Joinable());

  mThread->join();
}

bool ttv::StandardThread::Joinable() const {
  if (mThread == nullptr) {
    return false;
  }

  return mThread->joinable();
}

ttv::StandardThreadFactory::~StandardThreadFactory() {}

TTV_ErrorCode ttv::StandardThreadFactory::CreateThread(
  ThreadProc threadProc, const std::string& name, std::shared_ptr<IThread>& result) {
  result = std::make_shared<StandardThread>(threadProc, name);

  return TTV_EC_SUCCESS;
}
