/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/core/internal/pch.h"

#include "twitchsdk/core/standardthreadapi.h"

#include <thread>

ttv::StandardThreadApi::~StandardThreadApi() {}

void ttv::StandardThreadApi::Sleep(uint64_t duration) {
  std::chrono::milliseconds durationMs(static_cast<long long>(duration));
  std::this_thread::sleep_for(durationMs);
}
