/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/core/internal/pch.h"

#include "twitchsdk/core/standardthreadsync.h"

#include <condition_variable>

ttv::StandardThreadSync::StandardThreadSync() : mFallthru(false) {}

TTV_ErrorCode ttv::StandardThreadSync::Suspend() {
  return SuspendFor(UINT_MAX);
}

TTV_ErrorCode ttv::StandardThreadSync::SuspendFor(uint duration) {
  std::unique_lock<std::mutex> lock(mMutex);

  if (mFallthru == false) {
    if (duration < UINT_MAX) {
      mSyncAtom.wait_for(lock, std::chrono::milliseconds(duration));
    } else {
      mSyncAtom.wait(lock);
    }
  }

  mFallthru = false;

  return TTV_EC_SUCCESS;
}

TTV_ErrorCode ttv::StandardThreadSync::Signal() {
  std::unique_lock<std::mutex> lock(mMutex);
  mFallthru = true;

  mSyncAtom.notify_one();

  return TTV_EC_SUCCESS;
}

TTV_ErrorCode ttv::StandardThreadSyncFactory::CreateThreadSync(
  std::shared_ptr<ttv::IThreadSync>& result, const std::string& name) {
  result = std::make_shared<StandardThreadSync>();

  return TTV_EC_SUCCESS;
}
