# core_win32

## Overview
* Implements Windows-specific primitive and service support.

## Custom Switches
|             Switch                        |  Meaning  |
|-------------------------------------------|-----------|
| TTV_USEALL_WIN32_IMPLEMENTATIONS | Pulls in all Win32 primitive implementations.  This is the same as defining all *TTV_USE_WIN32_**.  |
| TTV_USE_WIN32_MUTEX | Pulls in WinMutex and WinMutexFactory and registers it as the mutex factory if none is already registered.  |
| TTV_USE_WIN32_RAW_SOCKET |  Pulls in WinSocket and WinSocketFactory and registers it as the "raw"/"tls" socket factory if none is already registered. |
| TTV_USE_WIN32_SYSTEM_CLOCK |  Pulls in WinSystemClock and registers it if none is already registered. |
| TTV_USE_WIN32_THREAD |  Pulls in WinThread and WinThreadFactory and registers it if none is already registered. |
| TTV_USE_WIN32_THREAD_SYNC |  Pulls in WinThreadSync and WinThreadSyncFactory and registers it if none is already registered. |
| TTV_USE_WIN32_TRACER | Pulls in WinTracer and registers it if none is already registered.  |
| TTV_USE_WIN32_HTTPREQUEST |  Pulls in WinINetHttpRequest and registers it if none is already registered. |
