/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/socket.h"
#include "twitchsdk/core/types/coretypes.h"
#include "twitchsdk/core/types/errortypes.h"

#include <array>

namespace ttv {
class WinSocket;
class WinSocketFactory;
class SecureWinSocketFactory;
}  // namespace ttv

class ttv::WinSocket : public ISocket {
 public:
  WinSocket();
  virtual ~WinSocket();

  TTV_ErrorCode Initialize(const std::string& host, const std::string& port);
  TTV_ErrorCode TCPListen(const std::string& host, const std::string& port);
  TTV_ErrorCode AcceptConnection(std::shared_ptr<ISocket>& newSocket);

  // ISocket implementation
  virtual TTV_ErrorCode Connect();
  virtual TTV_ErrorCode Disconnect();
  virtual TTV_ErrorCode Send(const uint8_t* buffer, size_t length, size_t& sent);
  virtual TTV_ErrorCode Recv(uint8_t* buffer, size_t length, size_t& received);
  virtual uint64_t TotalSent();
  virtual uint64_t TotalReceived();
  virtual bool Connected();

  static TTV_ErrorCode InitializeWinSock();
  static TTV_ErrorCode ShutdownWinSock();

 private:
  TTV_ErrorCode SetBlockingMode(bool block);

  std::string mHost;
  std::string mPort;
  size_t mSocket;
  int mLastSocketError;
  uint64_t mTotalSent;
  uint64_t mTotalReceived;
};

class ttv::WinSocketFactory : public ttv::ISocketFactory {
 public:
  virtual ~WinSocketFactory();
  virtual bool IsProtocolSupported(const std::string& protocol);
  virtual TTV_ErrorCode CreateSocket(const std::string& uri, std::shared_ptr<ISocket>& result);
};
