/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/thread.h"
#include "twitchsdk/core/types/coretypes.h"
#include "twitchsdk/core/types/errortypes.h"

namespace std {
class thread;
}

namespace ttv {
class WinThread;
class WinThreadFactory;
}  // namespace ttv

class ttv::WinThread : public IThread {
 public:
  WinThread(ThreadProc threadProc, const std::string& name);
  ~WinThread();

  virtual void Run();
  virtual bool Joinable() const;
  virtual void Join();

 private:
  ThreadProc mThreadProc;
  std::string mName;
  std::unique_ptr<std::thread> mThread;
};

class ttv::WinThreadFactory : public ttv::IThreadFactory {
 public:
  virtual ~WinThreadFactory();

  virtual TTV_ErrorCode CreateThread(ThreadProc threadProc, const std::string& name, std::shared_ptr<IThread>& result);
};
