/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/threadsync.h"

#include <windows.h>

namespace ttv {
class WinThreadSync;
class WinThreadSyncFactory;
}  // namespace ttv

class ttv::WinThreadSync : public IThreadSync {
 public:
  WinThreadSync();
  virtual ~WinThreadSync();

  virtual TTV_ErrorCode Suspend() override;
  virtual TTV_ErrorCode SuspendFor(uint duration) override;
  virtual TTV_ErrorCode Signal() override;

 private:
  HANDLE mSyncAtom;

  bool mFallthru;  // fall-thru will be on if a thread signal is signaled but without any threads suspended
                   // used for non windows implementations to emulate a self resetting event
};

class ttv::WinThreadSyncFactory : public IThreadSyncFactory {
 public:
  virtual TTV_ErrorCode CreateThreadSync(std::shared_ptr<IThreadSync>& result, const std::string& name = "") override;
};
