/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/core/internal/pch.h"

namespace ttv {
namespace assertion {
void PlatformAssert(const char* expr, const char* component, const char* message, const char* file, int line);
}
}  // namespace ttv

void ttv::assertion::PlatformAssert(
  const char* expr, const char* component, const char* message, const char* file, int line) {
#if _DEBUG
  // windows calls its assert failure function _wassert and it takes wide strings.
  // Note that a naive approach is taken to widening these things because it's assumed
  // that our own expressions and our own filenames are not widechar. I'm not even sure
  // that tacking L on to __FILE__ and a macro #stringify as MSVCRT's assert() macro does
  // is actually correct, anyways.
  size_t exprLen = strlen(expr) + 1;
  wchar_t* wexpr = (wchar_t*)_malloca(exprLen * sizeof(wchar_t));
  (void)std::copy(expr, expr + exprLen, wexpr);

  size_t fileLen = strlen(file) + 1;
  wchar_t* wfile = (wchar_t*)_malloca(fileLen * sizeof(wchar_t));
  (void)std::copy(file, file + fileLen, wfile);

  _wassert(wexpr, wfile, line);
#endif
}
