/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/core/internal/pch.h"

#include "twitchsdk/core/assertion.h"
#include "twitchsdk/core/memory.h"

#include <stdlib.h>

namespace ttv {
extern TTV_AllocCallback gAllocCallback;
extern TTV_FreeCallback gFreeCallback;

void* DefaultAlignedMalloc(size_t size, size_t alignment) {
  return _aligned_malloc(size, alignment);
}

void DefaultAlignedFree(void* p) {
  _aligned_free(p);
}
}  // namespace ttv

#if TTV_OUTPUT_DYNAMIC_LIBRARY && 0

#pragma warning(suppress : 28251)  // TODO: Correctly annotate
void* operator new(size_t size) {
  TTV_ASSERT(ttv::gAllocCallback);

#ifdef _M_X64
  const size_t alignment = 16;
#else
  const size_t alignment = 0;
#endif
  return ttv::gAllocCallback(size, alignment);
}

#pragma warning(suppress : 28251)  // TODO: Correctly annotate
void* operator new[](size_t size) {
  return operator new(size);
}

void operator delete(void* p) {
  TTV_ASSERT(ttv::gFreeCallback);

  ttv::gFreeCallback(p);
}

void operator delete[](void* p) {
  delete (p);
}

//--------------------------------------------------------------------
// We have overridden the following operator new because the MS std::thread and related classes
// use _concrt_new which uses these operators but they call the global delete, hence causing
// a mismatch
//--------------------------------------------------------------------

void* __CRTDECL operator new(size_t cb, int nBlockUse, const char* szFileName, int nLine)
//_THROW1(_STD bad_alloc)
{
  (nBlockUse);
  (szFileName);
  (nLine);
  return operator new(cb);
}

void* __CRTDECL operator new[](size_t cb, int nBlockUse, const char* szFileName, int nLine)
//_THROW1(_STD bad_alloc)
{
  (nBlockUse);
  (szFileName);
  (nLine);
  return operator new[](cb);
}

#endif
