/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/core/internal/pch.h"

#include "twitchsdk/core/winsystemclock.h"

#include "twitchsdk/core/assertion.h"

#include <windows.h>

ttv::WinSystemClock::WinSystemClock() : mFrequency(0) {
  auto qpfIsValid = QueryPerformanceFrequency(reinterpret_cast<LARGE_INTEGER*>(&mFrequency));
  TTV_ASSERT(qpfIsValid);
  TTV_ASSERT(mFrequency > 0);
}

uint64_t ttv::WinSystemClock::GetFrequency() {
  return mFrequency;
}

uint64_t ttv::WinSystemClock::GetTime() {
  uint64_t counter;
  (void)QueryPerformanceCounter(reinterpret_cast<LARGE_INTEGER*>(&counter));
  return counter;
}
