/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/httprequest.h"

namespace ttv {
class IXhr2HttpRequest;
}

class ttv::IXhr2HttpRequest : public HttpRequest {
 public:
  virtual TTV_ErrorCode ThreadInit();

  virtual TTV_ErrorCode SendHttpRequest(const std::string& requestName, const std::string& url,
    const std::vector<HttpParam>& requestHeaders, const std::string& requestBody, HttpRequestType httpReqType,
    uint timeOutInSecs, HttpRequestHeadersCallback headersCallback, HttpRequestCallback responseCallback,
    void* userData);

  virtual TTV_ErrorCode ThreadShutdown();
};
