/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/socket.h"
#include "twitchsdk/core/types/coretypes.h"
#include "twitchsdk/core/types/errortypes.h"

#include <Windows.Networking.Sockets.h>

#include <wrl.h>

#include <array>

namespace ttv {
class WinAppSocket;
class WinAppSocketFactory;
}  // namespace ttv

class ttv::WinAppSocket : public ISocket {
 public:
  WinAppSocket();
  virtual ~WinAppSocket();

  TTV_ErrorCode Initialize(const std::string& host, const std::string& port);

  // ISocket implementation
  virtual TTV_ErrorCode Connect();
  virtual TTV_ErrorCode Disconnect();
  virtual TTV_ErrorCode Send(const uint8_t* buffer, size_t length);
  virtual TTV_ErrorCode Recv(uint8_t* buffer, size_t length, size_t& received);
  virtual uint64_t TotalSent() const;
  virtual uint64_t TotalReceived() const;

  virtual bool Connected();

 private:
  HRESULT ReadAndResetInputBuffer(uint8_t* buffer, size_t length, UINT32& readLength);

  std::string mHostName;
  std::string mPort;
  int mLastSocketError;
  uint64_t mTotalSent;
  uint64_t mTotalRecieved;

  Microsoft::WRL::ComPtr<ABI::Windows::Networking::Sockets::IStreamSocket> mSocket;
  Microsoft::WRL::ComPtr<ABI::Windows::Storage::Streams::IBufferFactory> mBufferFactory;
  Microsoft::WRL::ComPtr<ABI::Windows::Storage::Streams::IBuffer> mInputBuffer;
  Microsoft::WRL::ComPtr<
    ABI::Windows::Foundation::IAsyncOperationWithProgress<ABI::Windows::Storage::Streams::IBuffer*, UINT32>>
    mAsyncReadOp;
  bool mAsyncReadInProgress;
};

class ttv::WinAppSocketFactory : public ttv::ISocketFactory {
 public:
  virtual ~WinAppSocketFactory();
  virtual bool IsProtocolSupported(const std::string& protocol);
  virtual TTV_ErrorCode CreateSocket(const std::string& uri, std::shared_ptr<ISocket>& result);
};
