set VISUAL_STUDIO_VERSION=%1%
set ARCHITECTURE=%2%

REM Determine the Visual Studio version
if "%VISUAL_STUDIO_VERSION%" == "vs2012" (
	set VCVARSALL_PATH="C:\Program Files (x86)\Microsoft Visual Studio 11.0\VC\vcvarsall.bat"
)
if "%VISUAL_STUDIO_VERSION%" == "vs2013" (
	set VCVARSALL_PATH="C:\Program Files (x86)\Microsoft Visual Studio 12.0\VC\vcvarsall.bat"
)
if "%VISUAL_STUDIO_VERSION%" == "vs2015" (
	set VCVARSALL_PATH="C:\Program Files (x86)\Microsoft Visual Studio 14.0\VC\vcvarsall.bat"
)
if "%VISUAL_STUDIO_VERSION%" == "vs2017" (
	if exist "C:\Program Files (x86)\Microsoft Visual Studio\2017\Professional" (set VCVARSALL_PATH="C:\Program Files (x86)\Microsoft Visual Studio\2017\Professional\VC\Auxiliary\Build\vcvarsall.bat")
	if exist "C:\Program Files (x86)\Microsoft Visual Studio\2017\Enterprise" (set VCVARSALL_PATH="C:\Program Files (x86)\Microsoft Visual Studio\2017\Enterprise\VC\Auxiliary\Build\vcvarsall.bat")
)

REM Determine the architecture and do script
if "%ARCHITECTURE%" == "x86" (
	set CONFIGURE_PLATFORM=VC-WIN32
	set DO_SCRIPT=ms\do_ms
)
if "%ARCHITECTURE%" == "x64" (
	set CONFIGURE_PLATFORM=VC-WIN64A
	set DO_SCRIPT=ms\do_win64a
)

echo CONFIGURE_PLATFORM = %CONFIGURE_PLATFORM%

echo Running vcvarsall.bat...
call %VCVARSALL_PATH% %ARCHITECTURE%

echo Building OpenSSL...

pushd %~dp0\src

set PREFIX_NAME=bin_%VISUAL_STUDIO_VERSION%_%ARCHITECTURE%
set PREFIX_DIR=%cd%\%PREFIX_NAME%
perl Configure %CONFIGURE_PLATFORM% no-asm no-shared no-dtls --prefix=%PREFIX_DIR% --openssldir=%PREFIX_DIR%

REM Clean the previous intermediate files
nmake clean

REM Build OpenSSL as a static library
nmake

REM Run some tests to make sure your build works - look for "passed all tests"
nmake test

REM Copy files to your output folder
nmake install

popd


pushd %~dp0

REM Copy static library files
:COPY_STATIC_FILES

set SRC_LIB_DIR=.\src\%PREFIX_NAME%\lib
set DEST_LIB_DIR=.\lib\%VISUAL_STUDIO_VERSION%\%ARCHITECTURE%

echo SRC_LIB_DIR=%SRC_LIB_DIR%
echo DEST_LIB_DIR=%DEST_LIB_DIR%

if NOT exist ".\lib" ( mkdir ".\lib" )
if NOT exist ".\lib\%VISUAL_STUDIO_VERSION%" ( mkdir ".\lib\%VISUAL_STUDIO_VERSION%" )
if NOT exist "%DEST_LIB_DIR%" ( mkdir "%DEST_LIB_DIR%" )
del /s /q "%DEST_LIB_DIR%\*"
xcopy "%SRC_LIB_DIR%\*" "%DEST_LIB_DIR%" /y


REM Copy headers
:COPY_HEADERS

set SRC_INCLUDE_DIR=.\src\%PREFIX_NAME%\include
set DEST_INCLUDE_DIR=.\include\%VISUAL_STUDIO_VERSION%\%ARCHITECTURE%

echo SRC_INCLUDE_DIR=%SRC_INCLUDE_DIR%
echo DEST_INCLUDE_DIR=%DEST_INCLUDE_DIR%

if NOT exist ".\include" ( mkdir ".\include" )
if NOT exist ".\include\%VISUAL_STUDIO_VERSION%" ( mkdir ".\include\%VISUAL_STUDIO_VERSION%" )
if NOT exist "%DEST_INCLUDE_DIR%" ( mkdir "%DEST_INCLUDE_DIR%" )
del /s /q "%DEST_INCLUDE_DIR%\*.*"
xcopy "%SRC_INCLUDE_DIR%\*" "%DEST_INCLUDE_DIR%" /y /s /e

popd
