#pragma once

#include <string>

// TODO: Them IConsoleInputProvider implementations should be moved to their own files
// when we have non-trivial implementations
class IConsoleInputProvider {
 public:
  virtual bool GetLine(std::string& line) = 0;
};

#if TTV_TARGET_IOS

class IosConsoleInputProvider : public IConsoleInputProvider {
 public:
  virtual bool GetLine(std::string& line) override;
};

#else

class StdInConsoleInputProvider : public IConsoleInputProvider {
 public:
  virtual bool GetLine(std::string& line) override;
};

#endif

int run(int argc, char* argv[]);
