#pragma once

#include "context.h"

class StaticInitializationRegistrar {
 public:
  typedef std::function<void(std::shared_ptr<Context> context)> InitializerFunction;
  typedef std::function<void(std::shared_ptr<Context> context, ttv::UserId userId)> UserLoginFunction;
  typedef std::function<void(std::shared_ptr<Context> context, ttv::UserId userId)> UserLogoutFunction;

 public:
  static StaticInitializationRegistrar& GetInstance();

  void RegisterInitializer(InitializerFunction func, int priority);
  void RegisterUserLoginFunction(UserLoginFunction func);
  void RegisterUserLogoutFunction(UserLogoutFunction func);

  void RunInitializers(std::shared_ptr<Context> context);
  void RunUserLogin(std::shared_ptr<Context> context, ttv::UserId userId);
  void RunUserLogout(std::shared_ptr<Context> context, ttv::UserId userId);

 private:
  struct Initializer {
    InitializerFunction func;
    int priority;
  };

  StaticInitializationRegistrar();

  std::vector<Initializer> mInitializers;
  std::vector<UserLoginFunction> mLoginFunctions;
  std::vector<UserLogoutFunction> mLogoutFunctions;
};

class StaticInitializer {
 public:
  typedef std::function<void()> RegisterFunction;

 public:
  StaticInitializer(RegisterFunction func);
};
