#pragma once

#include "twitchsdk/core/module.h"
#include "twitchsdk/core/stringutilities.h"

#include <string>
#include <vector>

namespace ttv {
std::string TrimStringQuotes(const std::string& str);
void Split(const std::string& str, std::vector<std::string>& out, char sep);
std::string Escape(const std::string& str);
void ToLowerCase(std::string& str);
bool ParseCommand(const std::string& line, std::string& command, std::string& params);
void TokenizeParameters(const std::string& str, std::vector<std::string>& out);
const char* AdvanceToNextWord(const char* str);
std::string ToString(Timestamp timestamp);
std::string ToString(ttv::IModule::State state);
std::string ToString(ttv::VodType type);
std::string ToString(ttv::BroadcastPlatform type);
std::string ToString(ttv::StreamType type);
void Print(const UserInfo& userInfo, std::string indent);
void Print(const std::vector<UserInfo>& userInfoList, std::string indent);
void Print(const ChannelInfo& channelInfo, std::string indent);
void Print(const PreviewImages& images, std::string indent);

void Print(const StreamInfo& streamInfo, std::string indent);
void Print(const StreamInfoUpdate& streamInfoUpdate, std::string indent);
void Print(const WatchPartyUpdate& update, std::string indent);
void Print(const ProfileImage& image, std::string indent);
void Print(const SquadStatus& squad, std::string indent);
void Print(const SquadMember& squadMember, std::string indent);
void Print(const SquadInfo& squad, std::string indent);
void Print(const CanTheyError& error, std::string indent);

bool ReadFileLines(const std::string& path, std::vector<std::string>& lines);
std::string CommaSeparatedStrings(
  const std::vector<std::pair<bool, std::string>>& optionalStrings, const std::string& emptyPlaceholder);
std::string ContainerizedPath(const std::string& path);
}  // namespace ttv

#define PRINT_VARIABLE(x) #x << ": " << x
#define PRINT_FIELD(obj, x) #x << ": " << (obj).x
#define PRINT_PTR_FIELD(obj, x) #x << ": " << (obj)->x
#define PRINT_BOOL_FIELD(obj, x) #x << ": " << ((obj).x ? "true" : "false")
#define PRINT_PTR_NULLABLE_FIELD(obj, x) #x << ": " << ((obj)->x == nullptr ? "null" : (obj)->x)
#define PRINT_NULLABLE_FIELD(obj, x) #x << ": " << ((obj).x == nullptr ? "null" : (obj).x)
#define PRINT_TIMESTAMP_FIELD(obj, x) #x << ": " << (obj).x << " (" << ::ToString((obj).x) << ")"
