#include "staticinit.h"

StaticInitializationRegistrar& StaticInitializationRegistrar::GetInstance() {
  static StaticInitializationRegistrar instance;
  return instance;
}

void StaticInitializationRegistrar::RunInitializers(std::shared_ptr<Context> context) {
  for (const auto& entry : mInitializers) {
    entry.func(context);
  }
}

void StaticInitializationRegistrar::RunUserLogin(std::shared_ptr<Context> context, ttv::UserId userId) {
  for (auto func : mLoginFunctions) {
    func(context, userId);
  }
}

void StaticInitializationRegistrar::RunUserLogout(std::shared_ptr<Context> context, ttv::UserId userId) {
  for (auto func : mLogoutFunctions) {
    func(context, userId);
  }
}

void StaticInitializationRegistrar::RegisterInitializer(InitializerFunction func, int priority) {
  Initializer entry;
  entry.func = func;
  entry.priority = priority;

  // Insert in priority order
  auto iter = mInitializers.begin();
  while (iter != mInitializers.end()) {
    if (iter->priority <= priority) {
      ++iter;
    } else {
      mInitializers.insert(iter, entry);
      return;
    }
  }

  mInitializers.push_back(entry);
}

void StaticInitializationRegistrar::RegisterUserLoginFunction(UserLoginFunction func) {
  mLoginFunctions.push_back(func);
}

void StaticInitializationRegistrar::RegisterUserLogoutFunction(UserLogoutFunction func) {
  mLogoutFunctions.push_back(func);
}

StaticInitializationRegistrar::StaticInitializationRegistrar() {}

StaticInitializer::StaticInitializer(RegisterFunction func) {
  func();
}
