import gtest_test_utils
import string
import sys

def MakeListOfTestsInFixture():

    exepath = None
    fixtureName = None

    for argString in sys.argv:
        if "--exepath=" in argString:
            exepath = argString[10:]
        if "--fixture=" in argString:
            fixtureName = argString[10:]

    if exepath == None:
        print "\nERROR: The test executable must be specified with --exepath=<Full path of executable>"
        return

    if fixtureName == None:
        print"\nERROR: The test fixture name must be specified with --fixture==<Fixture name>"
        return

    testListString = gtest_test_utils.Subprocess(exepath + " --gtest_list_tests", capture_stderr=False).output

    bInSpecifiedFixture = False
    testNames = []

    for line in testListString.split("\n", testListString.count("\n")):
        if bInSpecifiedFixture == True:
            if "." in line: # this indicates the start of a new fixture
                break
            else:
                testNames.append(fixtureName + "." + line[2:])
        else:
            if (fixtureName + ".") in line:
                bInSpecifiedFixture = True

    # we now have a list of complete names for every test in the memory fixture
    for name in testNames:
        print name

    # GGH - TODO: Dump the output to a file or something (instead of printing) so Jenkins can run it with --gtest_filter=...

if __name__ == "__main__":
    MakeListOfTestsInFixture()
