/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "pubsubtestutility.h"
#include "testhttprequest.h"
#include "twitchsdk/core/component.h"
#include "twitchsdk/core/coreapi.h"
#include "twitchsdk/core/module.h"
#include "usertestutility.h"

#include "gtest/gtest.h"

namespace ttv {
class ISystemClock;
class TestEventSchedulerFactory;
class UserRepository;

namespace test {
class SdkBaseTest;
class TestSocketFactory;
class TestSystemClock;
}  // namespace test
}  // namespace ttv

class ttv::test::SdkBaseTest : public ::testing::Test {
 protected:
  void AddModule(std::shared_ptr<ttv::IModule> module);
  void RemoveModule(std::shared_ptr<ttv::IModule> module);

  void AddComponent(std::shared_ptr<ttv::Component> component);
  void RemoveComponent(std::shared_ptr<ttv::Component> component);

  std::shared_ptr<TaskRunner> CreateTaskRunner();
  std::shared_ptr<TaskRunner> GetTaskRunner() { return mTaskRunner; }

  std::shared_ptr<UserRepository> CreateUserRepository();
  std::shared_ptr<UserRepository> GetUserRepository() { return mUserRepository; }

  std::function<void()> GetDefaultUpdateFunc();

  virtual void SetUp() final;
  virtual void TearDown() final;

  virtual void SetUpStubs();
  virtual void SetUpComponents();
  virtual void TearDownStubs();
  virtual void TearDownComponents();

  virtual void Update();
  virtual void UpdateModules();
  virtual void UpdateComponents();
  virtual void UpdateTaskRunner();

  TTV_ErrorCode LogIn(const std::shared_ptr<CoreAPI>& coreApi, const std::string& oauth, const UserInfo& userInfo);
  TTV_ErrorCode LogOut(const std::shared_ptr<CoreAPI>& coreApi, const UserInfo& userInfo);

  bool WaitUntilResult(uint waitUntilMilliSeconds, std::function<bool()> checkForResults);

 protected:
  std::shared_ptr<TestEventSchedulerFactory> mMainEventSchedulerFactory;
  std::shared_ptr<IBackgroundEventSchedulerFactory> mBackgroundEventSchedulerFactory;
  std::shared_ptr<TestHttpRequest> mHttpRequest;
  ttv::test::UserTestUtility mUserTestUtility;
  ttv::test::PubSubTestUtility mPubSubTestUtility;
  std::shared_ptr<TestSocketFactory> mTestSocketFactory;
  std::shared_ptr<TestSystemClock> mTestSystemClock;
  std::shared_ptr<ISystemClock> mPreviousSystemClock;
  std::shared_ptr<UserRepository> mUserRepository;

 private:
  std::shared_ptr<HttpRequest> mPreviousHttpRequest;
  std::shared_ptr<TaskRunner> mTaskRunner;

  std::vector<std::shared_ptr<ttv::IModule>> mModules;
  std::vector<std::shared_ptr<ttv::Component>> mComponents;
};
