/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/eventscheduler.h"

namespace ttv {
class TestEventSchedulerFactory;

namespace test {
class TestEventScheduler;
}
}  // namespace ttv

/**
 * An implemention of IMainEventSchedulerFactory that uses the TestEventScheduler.
 */
class ttv::TestEventSchedulerFactory : public IMainEventSchedulerFactory {
 public:
  virtual TTV_ErrorCode CreateMainEventScheduler(std::shared_ptr<IEventScheduler>& result) override;
  virtual TTV_ErrorCode CreateMainEventScheduler(
    const std::string& name, std::shared_ptr<IEventScheduler>& result) override;

  std::shared_ptr<test::TestEventScheduler> GetMainEventScheduler() const { return mMainEventScheduler; }

 private:
  std::shared_ptr<test::TestEventScheduler> mMainEventScheduler;
};
