#pragma once

#include "twitchsdk/core/types/coretypes.h"

#include <functional>
#include <vector>

namespace ttv {
namespace test {
class TestListenerHelper;
}
}  // namespace ttv

#define DECLARE_TEST_LISTENER_CALLBACK(TYPE)                  \
 private:                                                     \
  std::vector<TYPE##Func> m##TYPE;                            \
                                                              \
 public:                                                      \
  void Add##TYPE(TYPE##Func cb) { AddCallback(m##TYPE, cb); } \
  void Remove##TYPE(TYPE##Func cb) { RemoveCallback(m##TYPE, cb); }

class ttv::test::TestListenerHelper {
 protected:
  // template<typename T, typename... U>
  // void* GetStdFunctionAddress(std::function<T(U...)> func)
  //{
  //  typedef T(FunctionType)(U...);
  //  FunctionType** p = func.template target<FunctionType*>();
  //  return reinterpret_cast<void*>(*p);
  //}

  template <typename T>
  void AddCallback(std::vector<T>& list, T& cb) {
    const void* p = reinterpret_cast<const void*>(cb.template target<void>());
    auto iter = std::find_if(list.begin(), list.end(), [p](const T& cur) {
      const void* pCur = reinterpret_cast<const void*>(cur.template target<void>());
      return p == pCur;
    });

    if (iter == list.end()) {
      list.push_back(cb);
    }
  }

  template <typename T>
  void RemoveCallback(std::vector<T>& list, T& cb) {
    const void* p = reinterpret_cast<void*>(cb.template target<void>());
    auto iter = std::find_if(list.begin(), list.end(), [p](const T& cur) {
      const void* pCur = reinterpret_cast<const void*>(cur.template target<void>());
      return p == pCur;
    });

    if (iter != list.end()) {
      list.erase(iter);
    }
  }
};
