/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/socket.h"

#include <type_traits>

#include <map>

namespace ttv {
namespace test {
class TestSocketFactory;
class TestSocket;
}  // namespace test
}  // namespace ttv

class ttv::test::TestSocketFactory : public ttv::ISocketFactory {
 public:
  using CreateSocketFunc = std::function<void(const std::string& uri, const std::shared_ptr<ISocket>& socket)>;

 public:
  void SetSocket(const std::shared_ptr<ttv::ISocket>& socket, const std::string& uri);
  void SetSocketCreationCallback(CreateSocketFunc&& func) { mCreateSocketFunc = func; }

  // ISocketFactory implementation
  virtual TTV_ErrorCode CreateSocket(const std::string& uri, std::shared_ptr<ISocket>& result) override;
  virtual bool IsProtocolSupported(const std::string& protocol) override;

 private:
  CreateSocketFunc mCreateSocketFunc;

  std::map<std::string, std::shared_ptr<ttv::ISocket>> mSocketMap;
};
