/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/
#pragma once

#include "twitchsdk/core/systemclock.h"

namespace ttv {
namespace test {
class TestSystemClock;
}
}  // namespace ttv

class ttv::test::TestSystemClock : public ttv::ISystemClock {
 public:
  TestSystemClock(const std::shared_ptr<ISystemClock>& wrappedClock);

  void SetUseUnderlyingClock(bool use);
  void Advance(uint64_t milliseconds);
  void SetOffset(uint64_t milliseconds);
  void Reset();

  virtual uint64_t GetFrequency() override;
  virtual uint64_t GetTime() override;

 private:
  uint64_t mOffsetMilliseconds;
  std::shared_ptr<ISystemClock> mWrappedClock;
  bool mUseUnderlyingClock;
};
