#pragma once

#include "testeventscheduler.h"
#include "twitchsdk/core/component.h"
#include "twitchsdk/core/module.h"
#include "twitchsdk/core/task/taskrunner.h"
#include "twitchsdk/core/types/coretypes.h"
#include "twitchsdk/core/user/user.h"
#include "twitchsdk/core/user/userrepository.h"

#include "gtest/gtest.h"

namespace ttv {
namespace test {
bool WaitUntilResultWithPollTask(
  uint waitUntilMilliseconds, std::function<bool()> checkForResults, std::function<void(uint64_t)> pollFunction);
bool WaitUntilResultWithPollTask(
  uint waitUntilMilliseconds, std::function<bool()> checkForResults, std::function<void()> pollFunction);
bool WaitUntilResultWithPollTask(const std::shared_ptr<ttv::test::TestEventScheduler>& eventScheduler,
  uint waitUntilMilliseconds, std::function<bool()> checkForResults, std::function<void()> pollFunction);

void InitializeModule(const std::shared_ptr<ttv::IModule>& module);
void ShutdownModule(const std::shared_ptr<ttv::IModule>& module);

/**
 * Shuts down the given modules in order.
 */
void ShutdownModules(const std::vector<std::shared_ptr<ttv::IModule>>& modules);

void InitializeComponent(const std::shared_ptr<ttv::Component>& instance);
void InitializeComponent(const std::shared_ptr<ttv::Component>& instance, uint timeout, TTV_ErrorCode expectedError);
void ShutdownComponent(const std::shared_ptr<ttv::Component>& instance);
void ShutdownComponent(const std::shared_ptr<ttv::Component>& instance, uint timeout);
void ShutdownTaskRunner(const std::shared_ptr<ttv::TaskRunner>& taskRunner);
void EnsureEqual(const char* a, const char* b, bool copy);
}  // namespace test
}  // namespace ttv
