/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "fixtures/tasktest.h"

#include "testutilities.h"

using namespace ttv;

ttv::test::TaskTest::TaskTest() {
  mTaskRunner = std::make_shared<TaskRunner>();
}

ttv::test::TaskTest::~TaskTest() {
  ShutdownTaskRunner(mTaskRunner);
}

void ttv::test::TaskTest::Update() {
  SdkBaseTest::Update();

  if (mTaskRunner != nullptr) {
    mTaskRunner->PollTasks();
  }
}
