#include "twitchsdk.h"
#include "twitchsdk/core/assertion.h"
#include "twitchsdk/core/coreapi.h"

#include <signal.h>

#include <istream>

#include "gtest/gtest.h"

namespace {
const char* kClientId = "TEST_CLIENT_ID";
bool mPromptOnExit = false;
}  // namespace

bool NoAssert(
  const char* /*expr*/, const char* /*component*/, const char* /*message*/, const char* /*file*/, int /*line*/) {
  return true;
}

void PromptForExit() {
  if (mPromptOnExit) {
    std::cout << "press Enter to exit...";
    std::cin.ignore();
  }
}

extern "C" void HandleAbort(int /*signal_number*/) {
  PromptForExit();
}

// Some useful command line arguments:
// --gtest_break_on_failure
// --gtest_filter=ChatStressTest*

int main(int argc, char* argv[]) {
  signal(SIGABRT, &HandleAbort);

  for (int i = 0; i < argc; i++) {
    if (strcmp(argv[i], "--exitprompt") == 0) {
      mPromptOnExit = true;
    }
  }

  // TODO: Add a unit test to ensure that initializing without a client id fails
  ttv::SetClientId(kClientId);
  ttv::assertion::SetAssertHandler(NoAssert);

  ::testing::InitGoogleTest(&argc, argv);

  TTV_ErrorCode ec = TTV_InitializeLibrary();

  int ret = -1;

  if (TTV_SUCCEEDED(ec)) {
    ret = RUN_ALL_TESTS();

    ec = TTV_ShutdownLibrary();

    if (TTV_FAILED(ec)) {
      // TODO: Report an error shutting down the twitchsdk library
    }
  } else {
    // TODO: Report an error initializing the twitchsdk library
  }

  PromptForExit();
  return ret;
}
