/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/core/internal/pch.h"

#include "testeventschedulerfactory.h"

#include "testeventscheduler.h"

TTV_ErrorCode ttv::TestEventSchedulerFactory::CreateMainEventScheduler(std::shared_ptr<IEventScheduler>& result) {
  if (mMainEventScheduler == nullptr) {
    mMainEventScheduler = std::make_shared<test::TestEventScheduler>();
  }

  result = mMainEventScheduler;

  return TTV_EC_SUCCESS;
}

TTV_ErrorCode ttv::TestEventSchedulerFactory::CreateMainEventScheduler(
  const std::string& name, std::shared_ptr<IEventScheduler>& result) {
  if (mMainEventScheduler == nullptr) {
    mMainEventScheduler = std::make_shared<test::TestEventScheduler>(name);
  }

  result = std::make_shared<test::TestEventScheduler>(name);

  return TTV_EC_SUCCESS;
}
