/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "testsocketfactory.h"

void ttv::test::TestSocketFactory::SetSocket(const std::shared_ptr<ttv::ISocket>& socket, const std::string& uri) {
  mSocketMap[uri] = socket;
}

TTV_ErrorCode ttv::test::TestSocketFactory::CreateSocket(const std::string& uri, std::shared_ptr<ISocket>& result) {
  result = mSocketMap[uri];

  if (result != nullptr) {
    if (mCreateSocketFunc != nullptr) {
      mCreateSocketFunc(uri, result);
    }

    return TTV_EC_SUCCESS;
  }

  return TTV_EC_UNIMPLEMENTED;
}

bool ttv::test::TestSocketFactory::IsProtocolSupported(const std::string& protocol) {
  return protocol == "" || protocol == "tcp";
}
