/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/
#include "testsystemclock.h"

#include <chrono>

ttv::test::TestSystemClock::TestSystemClock(const std::shared_ptr<ISystemClock>& wrappedClock)
    : mOffsetMilliseconds(0), mWrappedClock(wrappedClock), mUseUnderlyingClock(true) {}

void ttv::test::TestSystemClock::SetUseUnderlyingClock(bool /*use*/) {}

void ttv::test::TestSystemClock::Advance(uint64_t milliseconds) {
  mOffsetMilliseconds += milliseconds;
}

void ttv::test::TestSystemClock::SetOffset(uint64_t milliseconds) {
  mOffsetMilliseconds = milliseconds;
}

void ttv::test::TestSystemClock::Reset() {
  mOffsetMilliseconds = 0;
}

uint64_t ttv::test::TestSystemClock::GetFrequency() {
  return mWrappedClock->GetFrequency();
}

uint64_t ttv::test::TestSystemClock::GetTime() {
  if (mUseUnderlyingClock) {
    return mWrappedClock->GetTime() + ttv::MsToSystemTime(mOffsetMilliseconds);
  } else {
    return ttv::MsToSystemTime(mOffsetMilliseconds);
  }
}
