/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/types/coretypes.h"
#include "twitchsdk/core/types/errortypes.h"

#include <map>

namespace ttv {
namespace experiment {
struct ExperimentSet;
namespace utils {

/**
 @brief Determines the experiment bucket a particular device or user belongs to,
 The bucket is determined statically using a hash built from the experiment's GUID, the device or user id, and the
 experiment's shuffle id. This hash is then compared with the weights of the experiment's groups to obtain a resulting
 bucket.
 @param experimentGuid The experiment's identifier
 @param experimentSet The available experiments, mapping GUID to experiment.
 @param deviceId The device id, used for DeviceId-type experiments.
 @param userId The user id, used for UserId-type experiments.. Use 0 if user is not logged in.
 @param result The bucket that was determined for the given experiment and parameters
 @return TTV_ErrorCode
 - TTV_EC_INVALID_ARG if the experiment is not found in the set
 - TTV_EC_NOT_AVAILABLE if the experiment has no groups
 - TTV_EC_INVALID_STATE if the experiment is of type DeviceId and the deviceId is empty
 - TTV_EC_SUCCESS if the lookup was successful
 */
TTV_ErrorCode DetermineBucket(const std::string& experimentGuid, const ttv::experiment::ExperimentSet& experimentSet,
  const std::string& deviceId, const ttv::UserId& userId, const std::map<std::string, std::string>& overrides,
  std::string& result);
}  // namespace utils
}  // namespace experiment
}  // namespace ttv
