#pragma once

#include "twitchsdk/core/json/value.h"
#include "twitchsdk/core/task/httptask.h"

namespace ttv {
namespace experiment {
struct ExperimentData;
struct ExperimentSet;
class FetchExperimentsTask;
}  // namespace experiment
}  // namespace ttv

class ttv::experiment::FetchExperimentsTask : public ttv::HttpTask {
 public:
  using Callback =
    std::function<void(FetchExperimentsTask* source, TTV_ErrorCode ec, const std::shared_ptr<ExperimentSet>& result)>;

 public:
  FetchExperimentsTask(Callback callback);

  void ProcessResponse(uint statusCode, const std::vector<char>& response) override;
  void OnComplete() override;

  static TTV_ErrorCode ParseExperimentSet(const std::string& json, ExperimentSet& result);

 protected:
  virtual const char* GetTaskName() const override { return "FetchExperimentsTask"; }
  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;

  static TTV_ErrorCode ParseExperiment(const json::Value& jsonExperiment, ExperimentData& experiment);

 private:
  Callback mCallback;
  std::shared_ptr<ExperimentSet> mResult;
};
