/********************************************************************************************
 * Twitch Platforms SDK
 *
 * This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
 * may not be copied or used except in accordance with the terms of that agreement
 * Copyright (c) 2012-2018 Twitch Interactive, Inc.
 *********************************************************************************************/

// DO NOT EDIT THIS FILE - it is machine generated
// Output determined from l

#pragma once

#include "twitchsdk/core/optional.h"
#include "twitchsdk/core/variant.h"
#include "twitchsdk/core/json/jsonserialization.h"

namespace ttv
{
    namespace social
    {
        namespace graphql
        {
            namespace json
            {
                struct SetSessionStatusPayloadType;
                struct SetSessionStatusInputParams;
                struct SetSessionStatusAvailabilityInput;
                struct SetSessionStatusActivityType;
            }

            struct SetSessionStatusQueryInfo
            {
                enum class AvailabilityInput
                {
                    ONLINE,
                    IDLE,
                    OFFLINE,
                };

                enum class ActivityType
                {
                    PLAYING,
                    STREAMING,
                    WATCHING,
                };

                struct PayloadType
                {
                    int32_t setAgainInSeconds;
                };

                struct InputParams
                {
                    std::string authToken;
                    ttv::Optional<std::string> activityGameID;
                    std::string sessionId;
                    ttv::Optional<ActivityType> activityType;
                    ttv::Optional<std::string> activityUserId;
                    AvailabilityInput availability;
                };

                static constexpr const char* kTaskName = "GraphQLTask: SetSessionStatus";
                static constexpr auto kQuery = R"(
                    #gen_full
                    mutation SetSessionStatus($sessionId:String!, $availability:AvailabilityInput!, $activityGameID:String, $activityType:ActivityType, $activityUserId:String) {
                        setSessionStatus(input: {sessionID:$sessionId, availability:$availability, activity: { gameID:$activityGameID, type:$activityType, userID:$activityUserId } }) {
                            setAgainInSeconds
                        }
                    }
                )";
            };
        }
    }
}


struct ttv::social::graphql::json::SetSessionStatusPayloadType
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& payloadType)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<RequiredField>(MakeKeyPath("setSessionStatus", "setAgainInSeconds"), payloadType.setAgainInSeconds)
        );
    }
};


struct ttv::social::graphql::json::SetSessionStatusInputParams
{
    template <typename GraphQLType>
    static auto BindFields(GraphQLType& inputParams)
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_field<OptionalField>("activityGameID", inputParams.activityGameID),
            make_field<RequiredField>("sessionId", inputParams.sessionId),
            make_field<OptionalField>("activityType", inputParams.activityType),
            make_field<OptionalField>("activityUserId", inputParams.activityUserId),
            make_field<RequiredField>("availability", inputParams.availability)
        );
    }
};


struct ttv::social::graphql::json::SetSessionStatusAvailabilityInput
{
    static auto EnumMap()
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_enum_mapping_case_insensitive("ONLINE", SetSessionStatusQueryInfo::AvailabilityInput::ONLINE),
            make_enum_mapping_case_insensitive("IDLE", SetSessionStatusQueryInfo::AvailabilityInput::IDLE),
            make_enum_mapping_case_insensitive("OFFLINE", SetSessionStatusQueryInfo::AvailabilityInput::OFFLINE)
        );
    }
};


struct ttv::social::graphql::json::SetSessionStatusActivityType
{
    static auto EnumMap()
    {
        using namespace ttv::json;

        return std::make_tuple
        (
            make_enum_mapping_case_insensitive("PLAYING", SetSessionStatusQueryInfo::ActivityType::PLAYING),
            make_enum_mapping_case_insensitive("STREAMING", SetSessionStatusQueryInfo::ActivityType::STREAMING),
            make_enum_mapping_case_insensitive("WATCHING", SetSessionStatusQueryInfo::ActivityType::WATCHING)
        );
    }
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::social::graphql::SetSessionStatusQueryInfo::PayloadType>
{
    using Type = ObjectSchema<ttv::social::graphql::json::SetSessionStatusPayloadType>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::social::graphql::SetSessionStatusQueryInfo::InputParams>
{
    using Type = ObjectSchema<ttv::social::graphql::json::SetSessionStatusInputParams>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::social::graphql::SetSessionStatusQueryInfo::AvailabilityInput>
{
    using Type = EnumSchema<ttv::social::graphql::json::SetSessionStatusAvailabilityInput>;
};


template<>
struct ttv::json::DefaultSchemaProvider<ttv::social::graphql::SetSessionStatusQueryInfo::ActivityType>
{
    using Type = EnumSchema<ttv::social::graphql::json::SetSessionStatusActivityType>;
};
