/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/json/value.h"
#include "twitchsdk/core/task/httptask.h"
#include "twitchsdk/social/internal/task/socialjson.h"

namespace ttv {
namespace social {
class SocialGetFriendsPresenceTask;
}
}  // namespace ttv

class ttv::social::SocialGetFriendsPresenceTask : public ttv::HttpTask {
 public:
  static const uint32_t kMaxLimit = 500;

  struct PresenceEntry {
    Friend friendData;
    uint64_t presenceUpdateIndex;
  };

  struct Result {
    std::vector<PresenceEntry> presenceList;
  };

  using Callback =
    std::function<void(SocialGetFriendsPresenceTask* source, TTV_ErrorCode ec, const std::shared_ptr<Result>& result)>;

 public:
  SocialGetFriendsPresenceTask(UserId userId, const std::string& authToken, Callback callback);

 protected:
  virtual const char* GetTaskName() const { return "SocialGetFriendsPresenceTask"; }

  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo);
  virtual bool ProcessHeaders(uint statusCode, const std::map<std::string, std::string>& headers);
  virtual void ProcessResponse(uint statusCode, const std::vector<char>& response);
  virtual void OnComplete();

 private:
  std::shared_ptr<Result> mResult;
  Callback mCallback;
  UserId mUserId;
};
