/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/json/value.h"
#include "twitchsdk/core/task/httptask.h"
#include "twitchsdk/social/socialtypes.h"

namespace ttv {
namespace social {
class SocialPresenceSettingsTask;
}
}  // namespace ttv

class ttv::social::SocialPresenceSettingsTask : public ttv::HttpTask {
 public:
  struct Result {
    PresenceSettings settings;
  };

  using Callback =
    std::function<void(SocialPresenceSettingsTask* source, TTV_ErrorCode ec, const std::shared_ptr<Result>& result)>;

 public:
  SocialPresenceSettingsTask(UserId userId, const std::string& authToken, bool set, Callback callback);

  void SetSettings(const PresenceSettings& settings) { mSettings = settings; }

 protected:
  virtual const char* GetTaskName() const override { return "SocialPresenceSettingsTask"; }

  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;
  virtual void ProcessResponse(uint statusCode, const std::vector<char>& response) override;
  virtual void OnComplete() override;

 private:
  std::shared_ptr<Result> mResult;
  Callback mCallback;
  PresenceSettings mSettings;
  UserId mUserId;
  bool mSet;
};
