/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/json/value.h"
#include "twitchsdk/core/task/httptask.h"
#include "twitchsdk/core/user/user.h"
#include "twitchsdk/social/internal/task/socialjson.h"

namespace ttv {
namespace social {
class SocialRecommendedFriendsTask;
}
}  // namespace ttv

class ttv::social::SocialRecommendedFriendsTask : public ttv::HttpTask {
 public:
  enum class Action { Unset, Fetch, Dismiss };

  struct RecommendedFriendEntry {
    UserInfo userInfo;
  };

  struct Result {
    Result();

    std::vector<RecommendedFriendEntry> recommendedFriends;  // Used if action == Action::Fetch
    Action action;
  };

  using Callback =
    std::function<void(SocialRecommendedFriendsTask* source, TTV_ErrorCode ec, std::shared_ptr<Result> result)>;

 public:
  SocialRecommendedFriendsTask(UserId userId, const std::string& authToken, Callback callback);

  /**
   * Grab the latest list of recommended friends.
   */
  void Fetch();
  /**
   * Dismiss the named user from the list of recommended friends.
   */
  void Dismiss(UserId recommendedUserId);

 protected:
  virtual const char* GetTaskName() const override { return "SocialRecommendedFriendsTask"; }

  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo) override;
  virtual bool ProcessHeaders(uint statusCode, const std::map<std::string, std::string>& headers) override;
  virtual void ProcessResponse(uint statusCode, const std::vector<char>& response) override;
  virtual void OnComplete() override;

 private:
  bool ParseRecommendedFriendListJson(const json::Value& jArray);

  std::shared_ptr<Result> mResult;
  Callback mCallback;
  UserId mUserId;
  UserId mRecommendedUserId;
  Action mAction;
};
