/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/json/value.h"
#include "twitchsdk/core/task/httptask.h"
#include "twitchsdk/social/socialtypes.h"

namespace ttv {
namespace social {
class SocialUpdateFriendTask;
}
}  // namespace ttv

class ttv::social::SocialUpdateFriendTask : public ttv::HttpTask {
 public:
  enum class Action { SendRequest, AcceptRequest, RejectRequest, DeleteFriend, GetStatus };

  struct Result {
    Result();

    UpdateFriendResult result;
    FriendStatus status;
  };

  using Callback =
    std::function<void(SocialUpdateFriendTask* source, TTV_ErrorCode ec, const std::shared_ptr<Result>& result)>;

 public:
  SocialUpdateFriendTask(
    UserId userId, const std::string& authToken, UserId friendUserId, Action action, Callback callback);

 protected:
  virtual const char* GetTaskName() const { return "SocialUpdateFriendTask"; }

  virtual void FillHttpRequestInfo(HttpRequestInfo& requestInfo);
  virtual bool ProcessHeaders(uint statusCode, const std::map<std::string, std::string>& headers);
  virtual void ProcessResponse(uint statusCode, const std::vector<char>& response);
  virtual void OnComplete();

 private:
  std::shared_ptr<Result> mResult;
  Callback mCallback;
  UserId mUserId;
  UserId mFriendUserId;
  Action mAction;
};
