/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/types/errortypes.h"

#include <vector>

/**
 * The unique module identifier for social.
 */
const uint32_t TTV_MODULE_ID_TWITCH_SOCIAL = 2;

// NOTE: There are currently no custom error ids
#define TTV_SOCIAL_ERROR_IDS                  \
  BEGIN_ERROR_IDS(TTV_EC_SOCIAL_BEGIN_ERRORS) \
  END_ERROR_IDS(TTV_EC_SOCIAL_END_ERRORS)

#define USE_TTV_ERROR_ID(ec) ec,
#define USE_TTV_SUCCESS_ID(ec) ec = 0,
#define BEGIN_ERROR_IDS(ec) ec = CONSTRUCT_ERROR_ID_VALUE(TTV_MODULE_ID_TWITCH_SOCIAL, 1),
#define END_ERROR_IDS(ec) ec

/**
 * TTV_SocialErrorId - The error ids defined in social.
 */
enum TTV_SocialErrorId { TTV_SOCIAL_ERROR_IDS };

#undef BEGIN_ERROR_IDS
#undef END_ERROR_IDS
#undef USE_TTV_SUCCESS_ID
#undef USE_TTV_ERROR_ID

namespace ttv {
namespace social {
/**
 * Converts a strongly typed TTV_SocialErrorId to TTV_ErrorCode so it can be handled generically.
 */
inline TTV_ErrorCode ToErrorCode(TTV_SocialErrorId errorId) {
  return CONSTRUCT_ERROR_ID_VALUE(TTV_MODULE_ID_TWITCH_SOCIAL, errorId);
}

/**
 * The error code string lookup for social.  This is not normally used directly by clients.  Use ttv::ErrorToString()
 * instead.
 */
const char* SocialErrorToString(TTV_ErrorCode ec);

void GetSocialErrorCodeValues(std::vector<EnumValue>& result);
}  // namespace social
}  // namespace ttv
