/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/core/module.h"
#include "twitchsdk/social/socialtypes.h"

#include <map>
#include <memory>
#include <string>

namespace ttv {
namespace social {
class ISocialAPIListener;
}
}  // namespace ttv

/**
 * Listener interface for callbacks from the conversation system.
 */
class ttv::social::ISocialAPIListener : public ttv::IModuleListener {
 public:
  virtual void SocialFriendInfoChanged(UserId userId, const std::vector<Friend>& changes) = 0;
  virtual void SocialFriendshipChanged(
    UserId userId, const std::vector<Friend>& added, const std::vector<Friend>& removed) = 0;

  /**
   * Called when a realtime friend request has been received.
   */
  virtual void SocialRealtimeFriendRequestReceived(UserId userId, const FriendRequest& request) = 0;
  virtual void SocialUnreadFriendRequestCountChanged(UserId userId, uint32_t count) = 0;
  virtual void SocialFriendRequestRemoved(UserId userId, UserId otherUserId, FriendRequestRemovalReason reason) = 0;

  virtual void SocialPresenceSettingsChanged(UserId userId, const PresenceSettings& settings) = 0;
};
