/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/social/internal/pch.h"

#include "twitchsdk/social/socialerrortypes.h"

const char* ttv::social::SocialErrorToString(TTV_ErrorCode err) {
  const char* result = nullptr;

  switch (err) {
#define USE_TTV_ERROR_ID(ec) \
  case ec:                   \
    result = #ec;            \
    break;
#define USE_TTV_SUCCESS_ID(ec) \
  case ec:                     \
    result = #ec;              \
    break;
#define BEGIN_ERROR_IDS(ec) \
  case ec:                  \
    result = #ec;           \
    break;
#define END_ERROR_IDS(ec) \
  case ec:                \
    result = #ec;         \
    break;
    TTV_SOCIAL_ERROR_IDS
#undef BEGIN_ERROR_IDS
#undef END_ERROR_IDS
#undef USE_TTV_SUCCESS_ID
#undef USE_TTV_ERROR_ID
    default:
      break;
  }

  return result;
}

void ttv::social::GetSocialErrorCodeValues(std::vector<EnumValue>& result) {
#define USE_TTV_ERROR_ID(ec) result.emplace_back(#ec, static_cast<uint32_t>(ec));
#define USE_TTV_SUCCESS_ID(ec) result.emplace_back(#ec, static_cast<uint32_t>(ec));
#define BEGIN_ERROR_IDS(ec) result.emplace_back(#ec, static_cast<uint32_t>(ec));
#define END_ERROR_IDS(ec) result.emplace_back(#ec, static_cast<uint32_t>(ec));
  TTV_SOCIAL_ERROR_IDS
#undef BEGIN_ERROR_IDS
#undef END_ERROR_IDS
#undef USE_TTV_SUCCESS_ID
#undef USE_TTV_ERROR_ID
}
