/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/social/internal/pch.h"

#include "twitchsdk/social/internal/socialhelpers.h"

bool ttv::social::ParsePresenceUserAvailability(const std::string& str, PresenceUserAvailability& result) {
  if (str == "offline") {
    result = PresenceUserAvailability::Offline;
  } else if (str == "online") {
    result = PresenceUserAvailability::Online;
  } else if (str == "away" || str == "idle") {
    result = PresenceUserAvailability::Away;
  } else if (str == "busy") {
    result = PresenceUserAvailability::Busy;
  } else {
    ttv::trace::Message("ParsePresenceUserAvailability", MessageLevel::Debug, "Unrecognized string: %s", str.c_str());
    result = PresenceUserAvailability::Online;
    return false;
  }

  return true;
}

bool ttv::social::ParsePresenceSettingsAvailabilityOverride(
  const std::string& str, PresenceSettings::AvailabilityOverride& result) {
  if (str == "") {
    result = PresenceSettings::AvailabilityOverride::None;
  } else if (str == "offline") {
    result = PresenceSettings::AvailabilityOverride::Offline;
  } else if (str == "away") {
    result = PresenceSettings::AvailabilityOverride::Away;
  } else if (str == "busy") {
    result = PresenceSettings::AvailabilityOverride::Busy;
  } else {
    ttv::trace::Message(
      "ParsePresenceSettingsAvailabilityOverride", MessageLevel::Debug, "Unrecognized string: %s", str.c_str());
    result = PresenceSettings::AvailabilityOverride::None;
    return false;
  }
  return true;
}
