/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "twitchsdk/social/internal/pch.h"

#include "twitchsdk/social/socialtypes.h"

ttv::social::FeatureFlags::FeatureFlags() : friendList(false), friendRequests(false), presence(false) {}

ttv::social::FeatureFlags ttv::social::FeatureFlags::All() {
  FeatureFlags flags;
  flags.friendList = true;
  flags.friendRequests = true;
  flags.presence = true;
  return flags;
}

ttv::social::FeatureFlags ttv::social::FeatureFlags::None() {
  return {};
}

ttv::social::PresenceSettings::PresenceSettings()
    : availabilityOverride(AvailabilityOverride::None), shareActivity(false) {}

bool ttv::social::PresenceSettings::operator==(const PresenceSettings& rhs) {
  return (availabilityOverride == rhs.availabilityOverride) && (shareActivity == rhs.shareActivity);
}

bool ttv::social::PresenceSettings::operator!=(const PresenceSettings& rhs) {
  return !(*this == rhs);
}

ttv::social::BroadcastingActivity::BroadcastingActivity() : channelId(0), gameId(0) {}

ttv::social::WatchingActivity::WatchingActivity() : channelId(0), hostedChannelId(0), gameId(0) {}

ttv::social::PlayingActivity::PlayingActivity() : gameId(0) {}

ttv::social::PresenceStatus::PresenceStatus() : availability(PresenceUserAvailability::Offline), lastUpdate(0) {}

ttv::social::PresenceStatus::PresenceStatus(const PresenceStatus& source)
    : activity((source.activity != nullptr) ? source.activity->Clone() : nullptr),
      availability(source.availability),
      lastUpdate(source.lastUpdate) {}

ttv::social::PresenceStatus& ttv::social::PresenceStatus::operator=(const PresenceStatus& source) {
  activity = (source.activity != nullptr) ? source.activity->Clone() : nullptr;
  availability = source.availability;
  lastUpdate = source.lastUpdate;

  return *this;
}

ttv::social::Friend::Friend() : friendsSinceTime(0) {}

ttv::social::FriendRequest::FriendRequest() : requestTime(0) {}
