/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "fixtures/sdkbasetest.h"
#include "testsocialapilistener.h"
#include "twitchsdk/core/coreapi.h"
#include "twitchsdk/social/socialapi.h"

namespace ttv {
namespace social {
namespace test {
class SocialApiTest;
}
}  // namespace social
}  // namespace ttv

class ttv::social::test::SocialApiTest : public ttv::test::SdkBaseTest {
 public:
 protected:
  SocialApiTest();
  virtual ~SocialApiTest();

  void TestModuleInitialization();

  std::shared_ptr<ttv::CoreAPI> mCoreApi;
  std::shared_ptr<ttv::social::SocialAPI> mSocialApi;
  std::shared_ptr<TestSocialApiListener> mTestSocialApiListener;
};
