
/********************************************************************************************
 * Twitch Broadcasting SDK
 *
 * This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
 * may not be copied or used except in accordance with the terms of that agreement
 * Copyright (c) 2015-2016 Twitch Interactive, Inc.
 *********************************************************************************************/

#pragma once

#include "testutilities.h"
#include "twitchsdk/social/internal/task/socialfriendrequeststask.h"
#include "twitchsdk/social/internal/task/socialgetfriendspresencetask.h"

namespace ttv {
namespace test {
class SampleFriendData;
}
namespace social {
class IPresenceActivity;
}
}  // namespace ttv

/**
 * An object for populating sample friend data
 */
class ttv::test::SampleFriendData {
 public:
  /**
   * Initializes the friends list with JSON data from the file at the path specified.
   * The JSON data has the key "samplefriends" mapped to an array of userinfo JSON
   */
  SampleFriendData(const std::string& path);

  /**
   * Gets a pre-canned user info that was populated from JSON data
   */
  const UserInfo& GetFriendInfo(std::size_t index) const;

  /**
   * Gets a pre-canned presence activity that was populated from JSON data
   */
  const json::Value& GetActivityJson(std::size_t index) const;

  /**
   * The following three methods are conveniences for generating some of the compound friend types.
   */
  json::Value GeneratePresenceJson(const UserInfo& userInfo, Timestamp lastUpdate, Timestamp lastHeartbeat,
    uint64_t updateIndex, ttv::social::PresenceUserAvailability availability, const json::Value& activity) const;
  ttv::social::SocialFriendRequestsTask::FriendRequestEntry GenerateFriendRequestEntry(
    const UserInfo& userInfo, Timestamp requested) const;

  /**
   * Generates a random timestamp from some time in the last five years.
   */
  Timestamp GenerateRandomTimestamp() const;

 private:
  std::vector<UserInfo> mSampleUserInfos;
  std::vector<json::Value> mSampleActivityJson;
};
