#pragma once

#include "testlistener.h"
#include "testutilities.h"
#include "twitchsdk/social/sociallistener.h"

namespace ttv {
namespace social {
namespace test {
class TestSocialApiListener;
}
}  // namespace social
}  // namespace ttv

/**
 * A helper ISocialAPIListener implementation that proxies events into optional lambda calls.
 * Call Add* and Remove* where * is the name of the callback.
 */
class ttv::social::test::TestSocialApiListener : public ISocialAPIListener, public ttv::test::TestListenerHelper {
 public:
  using ModuleStateChangedFunc = std::function<void(IModule* source, IModule::State state, TTV_ErrorCode ec)>;
  using SocialFriendInfoChangedFunc = std::function<void(UserId userId, const std::vector<Friend>& changes)>;
  using SocialFriendshipChangedFunc =
    std::function<void(UserId userId, const std::vector<Friend>& added, const std::vector<Friend>& removed)>;
  using SocialRealtimeFriendRequestReceivedFunc = std::function<void(UserId userId, const FriendRequest& requestList)>;
  using SocialUnreadFriendRequestCountChangedFunc = std::function<void(UserId userId, uint32_t count)>;
  using SocialFriendRequestRemovedFunc =
    std::function<void(UserId userId, UserId otherUserId, FriendRequestRemovalReason reason)>;
  using SocialPresenceSettingsChangedFunc = std::function<void(UserId userId, const PresenceSettings& settings)>;

 public:
  TestSocialApiListener() {}

  // ISocialAPIListener implementation
 public:
  virtual void ModuleStateChanged(IModule* source, IModule::State state, TTV_ErrorCode ec) override;
  virtual void SocialFriendInfoChanged(UserId userId, const std::vector<Friend>& changes) override;
  virtual void SocialFriendshipChanged(
    UserId userId, const std::vector<Friend>& added, const std::vector<Friend>& removed) override;
  virtual void SocialRealtimeFriendRequestReceived(UserId userId, const FriendRequest& request) override;
  virtual void SocialUnreadFriendRequestCountChanged(UserId userId, uint32_t count) override;
  virtual void SocialFriendRequestRemoved(
    UserId userId, UserId otherUserId, FriendRequestRemovalReason reason) override;
  virtual void SocialPresenceSettingsChanged(UserId userId, const PresenceSettings& settings) override;

 private:
  DECLARE_TEST_LISTENER_CALLBACK(ModuleStateChanged)
  DECLARE_TEST_LISTENER_CALLBACK(SocialFriendInfoChanged)
  DECLARE_TEST_LISTENER_CALLBACK(SocialFriendshipChanged)
  DECLARE_TEST_LISTENER_CALLBACK(SocialRealtimeFriendRequestReceived)
  DECLARE_TEST_LISTENER_CALLBACK(SocialUnreadFriendRequestCountChanged)
  DECLARE_TEST_LISTENER_CALLBACK(SocialFriendRequestRemoved)
  DECLARE_TEST_LISTENER_CALLBACK(SocialPresenceSettingsChanged)
};
