/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "fixtures/socialapitest.h"

#include "testtransport.h"
#include "testutilities.h"

using namespace ttv;
using namespace ttv::social;

ttv::social::test::SocialApiTest::SocialApiTest() {
  mCoreApi = std::make_shared<CoreAPI>();

  mTestSocialApiListener = std::make_shared<TestSocialApiListener>();

  mSocialApi = std::make_shared<SocialAPI>();
  mSocialApi->SetCoreApi(mCoreApi);
  mSocialApi->SetListener(mTestSocialApiListener);

  AddModule(mCoreApi);
  AddModule(mSocialApi);
}

ttv::social::test::SocialApiTest::~SocialApiTest() {}

void ttv::social::test::SocialApiTest::TestModuleInitialization() {
  ttv::test::InitializeModule(mCoreApi);
  ttv::test::InitializeModule(mSocialApi);
}
