/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#include "testsocialapilistener.h"

#include "gtest/gtest.h"

using namespace ttv;
using namespace ttv::social;

void ttv::social::test::TestSocialApiListener::ModuleStateChanged(
  IModule* source, IModule::State state, TTV_ErrorCode ec) {
  auto copy = mModuleStateChanged;
  for (auto func : copy) {
    func(source, state, ec);
  }
}

void ttv::social::test::TestSocialApiListener::SocialFriendInfoChanged(
  UserId userId, const std::vector<Friend>& changes) {
  auto copy = mSocialFriendInfoChanged;
  for (auto func : copy) {
    func(userId, changes);
  }
}

void ttv::social::test::TestSocialApiListener::SocialFriendshipChanged(
  UserId userId, const std::vector<Friend>& added, const std::vector<Friend>& removed) {
  auto copy = mSocialFriendshipChanged;
  for (auto func : copy) {
    func(userId, added, removed);
  }
}

void ttv::social::test::TestSocialApiListener::SocialRealtimeFriendRequestReceived(
  UserId userId, const FriendRequest& request) {
  auto copy = mSocialRealtimeFriendRequestReceived;
  for (auto func : copy) {
    func(userId, request);
  }
}

void ttv::social::test::TestSocialApiListener::SocialUnreadFriendRequestCountChanged(UserId userId, uint32_t count) {
  auto copy = mSocialUnreadFriendRequestCountChanged;
  for (auto func : copy) {
    func(userId, count);
  }
}

void ttv::social::test::TestSocialApiListener::SocialFriendRequestRemoved(
  UserId userId, UserId otherUserId, FriendRequestRemovalReason reason) {
  auto copy = mSocialFriendRequestRemoved;
  for (auto func : copy) {
    func(userId, otherUserId, reason);
  }
}

void ttv::social::test::TestSocialApiListener::SocialPresenceSettingsChanged(
  UserId userId, const PresenceSettings& settings) {
  auto copy = mSocialPresenceSettingsChanged;
  for (auto func : copy) {
    func(userId, settings);
  }
}
