package tv.twitch.social;

import tv.twitch.IModuleListener;

public interface ISocialAPIListener extends IModuleListener {
    void socialFriendInfoChanged(int userId, SocialFriend[] changes);
    void socialFriendshipChanged(int userId, SocialFriend[] added, SocialFriend[] removed);
    void socialRealtimeFriendRequestReceived(int userId, SocialFriendRequest request);
    void socialUnreadFriendRequestCountChanged(int userId, int count);
    void socialFriendRequestRemoved(int userId, int otherUserId, SocialFriendRequestRemovedReason reason);
    void socialPresenceSettingsChanged(int userId, SocialPresenceSettings settings);
}
