package tv.twitch.social;

import tv.twitch.*;

public class SocialAPI extends NativeProxy implements IModule {
    public interface PostPresenceCallback { void invoke(ErrorCode ec); }
    public interface FetchPresenceSettingsCallback { void invoke(ErrorCode ec, SocialPresenceSettings settings); }
    public interface SetPresenceSettingsCallback { void invoke(ErrorCode ec); }
    public interface FetchFriendListCallback { void invoke(ErrorCode ec, SocialFriend[] friends); }
    public interface UpdateFriendshipCallback {
        void invoke(ErrorCode ec, SocialUpdateFriendResult result, SocialFriendStatus status);
    }
    public interface FetchFriendRequestsCallback { void invoke(ErrorCode ec, SocialFriendRequest[] requests); }
    public interface FetchUnreadFriendRequestCountCallback { void invoke(ErrorCode ec, int requestCount); }
    public interface MarkAllFriendRequestsReadCallback { void invoke(ErrorCode ec); }
    public interface FetchFriendStatusCallback { void invoke(ErrorCode ec, SocialFriendStatus status); }
    public interface FetchRecommendedFriendsCallback { void invoke(ErrorCode ec, UserInfo[] recommendedFriends); }
    public interface DismissRecommendedFriendCallback { void invoke(ErrorCode ec); }

    static { SocialErrorCode.forceClassInit(); }

    /**
     * @Deprecated use {@link SocialAPI(IJniThreadChecker)}
     */
    @Deprecated
    public SocialAPI() {
        super(PassThroughJniThreadValidator.INSTANCE);
    }

    public SocialAPI(IJniThreadChecker jniThreadChecker) { super(new JniThreadValidator(jniThreadChecker)); }

    private native long CreateNativeInstance();
    // AND-9927 Disposing a SocialAPI is safe from any thread
    private native void DisposeNativeInstance(long nativeObjectPointer);

    private native ErrorCode SetCoreApi(long nativeObjectPointer, CoreAPI coreApi);
    private native ErrorCode SetEnabledFeatures(long nativeObjectPointer, SocialFeatureFlags features);
    private native ErrorCode SetListener(long nativeObjectPointer, ISocialAPIListener listener);

    private native ModuleState GetState(long nativeObjectPointer);
    private native String GetModuleName(long nativeObjectPointer);
    private native ErrorCode Initialize(long nativeObjectPointer, InitializeCallback callback);
    private native ErrorCode Shutdown(long nativeObjectPointer, ShutdownCallback callback);
    private native ErrorCode Update(long nativeObjectPointer);

    private native ErrorCode SetPresenceSessionAvailability(
        long nativeObjectPointer, int userId, SocialPresenceSessionAvailability availability);
    private native ErrorCode AddWatchingActivity(
        long nativeObjectPointer, int userId, int channelId, ResultContainer<Integer> activityToken);
    private native ErrorCode AddPlayingActivity(long nativeObjectPointer, int userId, int gameId,
        String gameDisplayContext, ResultContainer<Integer> activityToken);
    private native ErrorCode RemoveActivity(long nativeObjectPointer, int userId, int activityToken);
    private native ErrorCode PostPresence(long nativeObjectPointer, int userId, PostPresenceCallback callback);
    private native ErrorCode FetchPresenceSettings(
        long nativeObjectPointer, int userId, FetchPresenceSettingsCallback callback);
    private native ErrorCode SetPresenceSettings(
        long nativeObjectPointer, int userId, SocialPresenceSettings settings, SetPresenceSettingsCallback callback);
    private native ErrorCode SetAutomaticPresencePostingEnabled(long nativeObjectPointer, int userId, boolean enabled);
    private native ErrorCode GetAutomaticPresencePostingEnabled(
        long nativeObjectPointer, int userId, ResultContainer<Boolean> enabled);
    private native ErrorCode FetchFriendList(long nativeObjectPointer, int userId, FetchFriendListCallback callback);
    private native ErrorCode UpdateFriendship(long nativeObjectPointer, int userId, int otherUserId,
        SocialUpdateFriendAction action, UpdateFriendshipCallback callback);
    private native ErrorCode FetchFriendRequests(
        long nativeObjectPointer, int userId, FetchFriendRequestsCallback callback);
    private native ErrorCode FetchUnreadFriendRequestCount(
        long nativeObjectPointer, int userId, FetchUnreadFriendRequestCountCallback callback);
    private native ErrorCode MarkAllFriendRequestsRead(
        long nativeObjectPointer, int userId, MarkAllFriendRequestsReadCallback callback);
    private native ErrorCode FetchRecommendedFriends(
        long nativeObjectPointer, int userId, FetchRecommendedFriendsCallback callback);
    private native ErrorCode DismissRecommendedFriend(
        long nativeObjectPointer, int userId, int dismissUserId, DismissRecommendedFriendCallback callback);
    private native ErrorCode FetchFriendStatus(
        long nativeObjectPointer, int userId, int otherUserId, FetchFriendStatusCallback callback);

    @Override
    protected long createNativeInstance() {
        return mJniThreadValidator.callJniCallable(new IJniCallable<Long>() {
            @Override
            public Long call() {
                return CreateNativeInstance();
            }
        });
    }

    @Override
    protected void disposeNativeInstance(long nativeObjectPointer) {
        // AND-9927 Disposing a SocialAPI is safe from any thread
        DisposeNativeInstance(nativeObjectPointer);
    }

    @Override
    public ModuleState getState() {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ModuleState>() {
            @Override
            public ModuleState call() {
                return GetState(getNativeObjectPointer());
            }
        });
    }

    @Override
    public String getModuleName() {
        return mJniThreadValidator.callJniCallable(new IJniCallable<String>() {
            @Override
            public String call() {
                return GetModuleName(getNativeObjectPointer());
            }
        });
    }

    public ErrorCode setCoreApi(final CoreAPI coreApi) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return SetCoreApi(getNativeObjectPointer(), coreApi);
            }
        });
    }

    public ErrorCode setEnabledFeatures(final SocialFeatureFlags featureFlags) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return SetEnabledFeatures(getNativeObjectPointer(), featureFlags);
            }
        });
    }

    public ErrorCode setListener(final ISocialAPIListener listener) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return SetListener(getNativeObjectPointer(), listener);
            }
        });
    }

    @Override
    public ErrorCode initialize(final InitializeCallback callback) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return Initialize(getNativeObjectPointer(), callback);
            }
        });
    }

    @Override
    public ErrorCode shutdown(final ShutdownCallback callback) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return Shutdown(getNativeObjectPointer(), callback);
            }
        });
    }

    @Override
    public ErrorCode update() {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return Update(getNativeObjectPointer());
            }
        });
    }

    public ErrorCode setPresenceSessionAvailability(
        final int userId, final SocialPresenceSessionAvailability availability) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return SetPresenceSessionAvailability(getNativeObjectPointer(), userId, availability);
            }
        });
    }

    public ErrorCode addWatchingActivity(
        final int userId, final int channelId, final ResultContainer<Integer> activityToken) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return AddWatchingActivity(getNativeObjectPointer(), userId, channelId, activityToken);
            }
        });
    }

    public ErrorCode addPlayingActivity(final int userId, final int gameId, final String gameDisplayContext,
        final ResultContainer<Integer> activityToken) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return AddPlayingActivity(getNativeObjectPointer(), userId, gameId, gameDisplayContext, activityToken);
            }
        });
    }

    public ErrorCode removeActivity(final int userId, final int activityToken) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return RemoveActivity(getNativeObjectPointer(), userId, activityToken);
            }
        });
    }

    public ErrorCode postPresence(final int userId, final PostPresenceCallback callback) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return PostPresence(getNativeObjectPointer(), userId, callback);
            }
        });
    }

    public ErrorCode fetchPresenceSettings(final int userId, final FetchPresenceSettingsCallback callback) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return FetchPresenceSettings(getNativeObjectPointer(), userId, callback);
            }
        });
    }

    public ErrorCode setPresenceSettings(
        final int userId, final SocialPresenceSettings settings, final SetPresenceSettingsCallback callback) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return SetPresenceSettings(getNativeObjectPointer(), userId, settings, callback);
            }
        });
    }

    public ErrorCode setAutomaticPresencePostingEnabled(final int userId, final boolean enabled) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return SetAutomaticPresencePostingEnabled(getNativeObjectPointer(), userId, enabled);
            }
        });
    }

    public ErrorCode getAutomaticPresencePostingEnabled(final int userId, final ResultContainer<Boolean> enabled) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return GetAutomaticPresencePostingEnabled(getNativeObjectPointer(), userId, enabled);
            }
        });
    }

    public ErrorCode fetchFriendList(final int userId, final FetchFriendListCallback callback) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return FetchFriendList(getNativeObjectPointer(), userId, callback);
            }
        });
    }

    public ErrorCode updateFriendship(final int userId, final int otherUserId, final SocialUpdateFriendAction action,
        final UpdateFriendshipCallback callback) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return UpdateFriendship(getNativeObjectPointer(), userId, otherUserId, action, callback);
            }
        });
    }

    public ErrorCode fetchFriendRequests(final int userId, final FetchFriendRequestsCallback callback) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return FetchFriendRequests(getNativeObjectPointer(), userId, callback);
            }
        });
    }

    public ErrorCode fetchUnreadFriendRequestCount(
        final int userId, final FetchUnreadFriendRequestCountCallback callback) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return FetchUnreadFriendRequestCount(getNativeObjectPointer(), userId, callback);
            }
        });
    }

    public ErrorCode fetchRecommendedFriends(final int userId, final FetchRecommendedFriendsCallback callback) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return FetchRecommendedFriends(getNativeObjectPointer(), userId, callback);
            }
        });
    }

    public ErrorCode dismissRecommendedFriend(
        final int userId, final int dismissUserId, final DismissRecommendedFriendCallback callback) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return DismissRecommendedFriend(getNativeObjectPointer(), userId, dismissUserId, callback);
            }
        });
    }

    public ErrorCode markAllFriendRequestsRead(final int userId, final MarkAllFriendRequestsReadCallback callback) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return MarkAllFriendRequestsRead(getNativeObjectPointer(), userId, callback);
            }
        });
    }

    public ErrorCode fetchFriendStatus(
        final int userId, final int otherUserId, final FetchFriendStatusCallback callback) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return FetchFriendStatus(getNativeObjectPointer(), userId, otherUserId, callback);
            }
        });
    }
}
