package tv.twitch.social;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum SocialFriendStatus {
    // BINDING_ENUM_START (Do not remove this line, it's used by the bindings tools)
    TTV_SOCIAL_FRIEND_STATUS_NO_RELATION(0),
    TTV_SOCIAL_FRIEND_STATUS_BLOCKED(1),
    TTV_SOCIAL_FRIEND_STATUS_BLOCKS(2),
    TTV_SOCIAL_FRIEND_STATUS_SENT_REQUEST(3),
    TTV_SOCIAL_FRIEND_STATUS_RECEIVED_REQUEST(4),
    TTV_SOCIAL_FRIEND_STATUS_FRIENDS(5),
    TTV_SOCIAL_FRIEND_STATUS_UNKNOWN(6);
    // BINDING_ENUM_END (Do not remove this line, it's used by the bindings tools)

    private static Map<Integer, SocialFriendStatus> s_Map = new HashMap<Integer, SocialFriendStatus>();

    static {
        EnumSet<SocialFriendStatus> set = EnumSet.allOf(SocialFriendStatus.class);

        for (SocialFriendStatus e : set) {
            s_Map.put(e.getValue(), e);
        }
    }

    public static SocialFriendStatus lookupValue(int val) {
        SocialFriendStatus err = s_Map.get(val);
        return err;
    }

    private int m_Value;

    private SocialFriendStatus(int value) { this.m_Value = value; }

    public int getValue() { return m_Value; }
}
